/************************************************************************
*
* Copyright:
*	Freescale Semiconductor, INC. All Rights Reserved.  
*  You are hereby granted a copyright license to use, modify, and
*  distribute the SOFTWARE so long as this entire notice is
*  retained without alteration in any modified and/or redistributed
*  versions, and that such modified versions are clearly identified
*  as such. No licenses are granted by implication, estoppel or
*  otherwise under any patents or trademarks of Freescale Semiconductor, 
*  Inc. This software is provided on an "AS IS" basis and without warranty.
*
*  To the maximum extent permitted by applicable law, FREESCALE 
*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
*  ACCOMPANYING WRITTEN MATERIALS.
* 
*  To the maximum extent permitted by applicable law, IN NO EVENT
*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
* 
*  Freescale assumes no responsibility for the maintenance and support
*  of this software
**********************************************
* FILE NAME: fir32.h
*
* PURPOSE: FIR32 module header file, containing general definitions and 
*	       function prototypes for allocating/deallocating data structures
*	       for filter and computing a Finite Impulse Responce filter.
*
* AUTHOR:  Andrey Butok
*********************************************/
#ifndef _FIR32_H_
#define _FIR32_H_

#include "fir.h"
/******************************************
*32-bit Fractional FIR Filter
******************************************/
 typedef struct tFir32Struct
	{
	Frac32* pFirCoef;                   // Coefficients for FIR -> {a0,a1,a2...}
	unsigned int    iFirCoefCount;      // Number of Coefficients
	Frac32* pFirHistory;                // Buffer for Save hisory between function calls-> {X1,X2,X3...}
	unsigned int    iFirHistoryCount;   // Number of values in History Buffer
	};

 //Computes a Finite Impulse Response for a array of 32-bit fractional data values.
 void FIR32_EMAC(struct tFir32Struct *pFIR, Frac32* pX, Frac32* pY, unsigned int n);
 void FIR32_MAC(struct tFir32Struct *pFIR, Frac32* pX, Frac32* pY, unsigned int n);

 //Performs the initalization for the FIR32 filter function.
struct tFir32Struct* FIR32Create( Frac32* pCoef, uint16 u16Num);

 //Deallocates the data structure(s) initially allocated by FIR32Create.
 void FIR32Destroy(struct tFir32Struct* pFirStruct);

#ifdef __EMAC
	#define FIR32(w,x,y,z)	FIR32_EMAC(w,x,y,z)
#else
	#define FIR32(w,x,y,z)	FIR32_MAC(w,x,y,z)
#endif

#endif //_FIR32_H_
